%------------------------------------------------------------------------------
% File     : ITP194^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Sturm_Tarski problem prob_257__5870986_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Sturm_Tarski/prob_257__5870986_1 [Des21]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0
% Syntax   : Number of formulae    :  371 (  77 unt;  53 typ;   0 def)
%            Number of atoms       :  994 ( 224 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 3143 ( 120   ~;  29   |;  65   &;2398   @)
%                                         (   0 <=>; 531  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   8 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  114 ( 114   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   54 (  51 usr;   7 con; 0-7 aty)
%            Number of variables   :  978 (  53   ^; 834   !;  47   ?; 978   :)
%                                         (  44  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:26:51.513
%------------------------------------------------------------------------------
% Could-be-implicit typings (4)
thf(ty_t_Polynomial_Opoly,type,
    poly: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (49)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom__divide,type,
    idom_divide: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom__abs__sgn,type,
    idom_abs_sgn: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Real__Vector__Spaces_Oreal__normed__vector,type,
    real_V55928688vector: 
      !>[A: $tType] : $o ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : $o ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Omin,type,
    ord_min: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Polynomial_Odivide__poly__main,type,
    divide_poly_main: 
      !>[A: $tType] : ( A > ( poly @ A ) > ( poly @ A ) > ( poly @ A ) > nat > nat > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Ois__zero,type,
    is_zero: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Oorder,type,
    order2: 
      !>[A: $tType] : ( A > ( poly @ A ) > nat ) ).

thf(sy_c_Polynomial_Opoly,type,
    poly2: 
      !>[A: $tType] : ( ( poly @ A ) > A > A ) ).

thf(sy_c_Polynomial_Opoly__cutoff,type,
    poly_cutoff: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opoly__shift,type,
    poly_shift: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Oreflect__poly,type,
    reflect_poly: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Osgn__neg__inf,type,
    sturm_1439882693eg_inf: 
      !>[A: $tType] : ( ( poly @ A ) > A ) ).

thf(sy_c_Sturm__Tarski__Mirabelle__osyjafhhev_Osgn__pos__inf,type,
    sturm_62398785os_inf: 
      !>[A: $tType] : ( ( poly @ A ) > A ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_lb1____,type,
    lb1: real ).

thf(sy_v_lb2____,type,
    lb2: real ).

thf(sy_v_lb____,type,
    lb: real ).

thf(sy_v_p,type,
    p: poly @ real ).

thf(sy_v_thesis,type,
    thesis: $o ).

% Relevant facts (254)
thf(fact_0_lb1,axiom,
    ! [X: real] :
      ( ( ( poly2 @ real @ p @ X )
        = ( zero_zero @ real ) )
     => ( ord_less @ real @ lb1 @ X ) ) ).

% lb1
thf(fact_1_lb__def,axiom,
    ( lb
    = ( ord_min @ real @ lb1 @ lb2 ) ) ).

% lb_def
thf(fact_2__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062lb1_O_A_092_060forall_062x_O_Apoly_Ap_Ax_A_061_A0_A_092_060longrightarrow_062_Alb1_A_060_Ax_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Lb1: real] :
        ~ ! [X: real] :
            ( ( ( poly2 @ real @ p @ X )
              = ( zero_zero @ real ) )
           => ( ord_less @ real @ Lb1 @ X ) ) ).

% \<open>\<And>thesis. (\<And>lb1. \<forall>x. poly p x = 0 \<longrightarrow> lb1 < x \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_3_assms,axiom,
    ( p
   != ( zero_zero @ ( poly @ real ) ) ) ).

% assms
thf(fact_4_poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [X2: A] :
          ( ( poly2 @ A @ ( zero_zero @ ( poly @ A ) ) @ X2 )
          = ( zero_zero @ A ) ) ) ).

% poly_0
thf(fact_5_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_6_poly__IVT__neg,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ A2 ) )
       => ( ( ord_less @ real @ ( poly2 @ real @ P @ B ) @ ( zero_zero @ real ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A2 @ X3 )
              & ( ord_less @ real @ X3 @ B )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_7_poly__IVT__pos,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( poly2 @ real @ P @ A2 ) @ ( zero_zero @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ B ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A2 @ X3 )
              & ( ord_less @ real @ X3 @ B )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_8_poly__all__0__iff__0,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ! [X4: A] :
                ( ( poly2 @ A @ P @ X4 )
                = ( zero_zero @ A ) ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% poly_all_0_iff_0
thf(fact_9_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_10_field__lbound__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [D1: A,D2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ D1 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ D2 )
           => ? [E: A] :
                ( ( ord_less @ A @ ( zero_zero @ A ) @ E )
                & ( ord_less @ A @ E @ D1 )
                & ( ord_less @ A @ E @ D2 ) ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_11_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_12_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_13_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_14_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_15_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X2: A] :
          ( ( ( zero_zero @ A )
            = X2 )
          = ( X2
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_16_poly__eq__poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A,Q: poly @ A] :
          ( ( ( poly2 @ A @ P )
            = ( poly2 @ A @ Q ) )
          = ( P = Q ) ) ) ).

% poly_eq_poly_eq_iff
thf(fact_17_min__less__iff__conj,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Z: A,X2: A,Y: A] :
          ( ( ord_less @ A @ Z @ ( ord_min @ A @ X2 @ Y ) )
          = ( ( ord_less @ A @ Z @ X2 )
            & ( ord_less @ A @ Z @ Y ) ) ) ) ).

% min_less_iff_conj
thf(fact_18_min_Oidem,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A] :
          ( ( ord_min @ A @ A2 @ A2 )
          = A2 ) ) ).

% min.idem
thf(fact_19_min_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_min @ A @ A2 @ ( ord_min @ A @ A2 @ B ) )
          = ( ord_min @ A @ A2 @ B ) ) ) ).

% min.left_idem
thf(fact_20_min_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_min @ A @ ( ord_min @ A @ A2 @ B ) @ B )
          = ( ord_min @ A @ A2 @ B ) ) ) ).

% min.right_idem
thf(fact_21_min_Ostrict__coboundedI2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [B: A,C: A,A2: A] :
          ( ( ord_less @ A @ B @ C )
         => ( ord_less @ A @ ( ord_min @ A @ A2 @ B ) @ C ) ) ) ).

% min.strict_coboundedI2
thf(fact_22_min_Ostrict__coboundedI1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less @ A @ A2 @ C )
         => ( ord_less @ A @ ( ord_min @ A @ A2 @ B ) @ C ) ) ) ).

% min.strict_coboundedI1
thf(fact_23_min_Ostrict__order__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_less @ A )
        = ( ^ [A3: A,B2: A] :
              ( ( A3
                = ( ord_min @ A @ A3 @ B2 ) )
              & ( A3 != B2 ) ) ) ) ) ).

% min.strict_order_iff
thf(fact_24_min_Ostrict__boundedE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ ( ord_min @ A @ B @ C ) )
         => ~ ( ( ord_less @ A @ A2 @ B )
             => ~ ( ord_less @ A @ A2 @ C ) ) ) ) ).

% min.strict_boundedE
thf(fact_25_min__less__iff__disj,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less @ A @ ( ord_min @ A @ X2 @ Y ) @ Z )
          = ( ( ord_less @ A @ X2 @ Z )
            | ( ord_less @ A @ Y @ Z ) ) ) ) ).

% min_less_iff_disj
thf(fact_26_is__zero__null,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( is_zero @ A )
        = ( ^ [P2: poly @ A] :
              ( P2
              = ( zero_zero @ ( poly @ A ) ) ) ) ) ) ).

% is_zero_null
thf(fact_27_min_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_min @ A @ B @ ( ord_min @ A @ A2 @ C ) )
          = ( ord_min @ A @ A2 @ ( ord_min @ A @ B @ C ) ) ) ) ).

% min.left_commute
thf(fact_28_min_Ocommute,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_min @ A )
        = ( ^ [A3: A,B2: A] : ( ord_min @ A @ B2 @ A3 ) ) ) ) ).

% min.commute
thf(fact_29_min_Oassoc,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_min @ A @ ( ord_min @ A @ A2 @ B ) @ C )
          = ( ord_min @ A @ A2 @ ( ord_min @ A @ B @ C ) ) ) ) ).

% min.assoc
thf(fact_30_poly__cutoff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_cutoff @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_cutoff_0
thf(fact_31_last__non__root__interval,axiom,
    ! [P: poly @ real,Ub: real] :
      ( ( P
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Lb: real] :
            ( ( ord_less @ real @ Lb @ Ub )
           => ~ ! [Z2: real] :
                  ( ( ( ord_less_eq @ real @ Lb @ Z2 )
                    & ( ord_less @ real @ Z2 @ Ub ) )
                 => ( ( poly2 @ real @ P @ Z2 )
                   != ( zero_zero @ real ) ) ) ) ) ).

% last_non_root_interval
thf(fact_32_next__non__root__interval,axiom,
    ! [P: poly @ real,Lb2: real] :
      ( ( P
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Ub2: real] :
            ( ( ord_less @ real @ Lb2 @ Ub2 )
           => ~ ! [Z2: real] :
                  ( ( ( ord_less @ real @ Lb2 @ Z2 )
                    & ( ord_less_eq @ real @ Z2 @ Ub2 ) )
                 => ( ( poly2 @ real @ P @ Z2 )
                   != ( zero_zero @ real ) ) ) ) ) ).

% next_non_root_interval
thf(fact_33_reflect__poly__at__0__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( ( poly2 @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ A ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_34_lb2,axiom,
    ! [X: real] :
      ( ( ord_less_eq @ real @ X @ lb2 )
     => ( ( sgn_sgn @ real @ ( poly2 @ real @ p @ X ) )
        = ( sturm_1439882693eg_inf @ real @ p ) ) ) ).

% lb2
thf(fact_35_poly__shift__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_shift @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_shift_0
thf(fact_36_order__root,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A2: A] :
          ( ( ( poly2 @ A @ P @ A2 )
            = ( zero_zero @ A ) )
          = ( ( P
              = ( zero_zero @ ( poly @ A ) ) )
            | ( ( order2 @ A @ A2 @ P )
             != ( zero_zero @ nat ) ) ) ) ) ).

% order_root
thf(fact_37_divide__poly__main__0,axiom,
    ! [A: $tType] :
      ( ( idom_divide @ A )
     => ! [R: poly @ A,D: poly @ A,Dr: nat,N: nat] :
          ( ( divide_poly_main @ A @ ( zero_zero @ A ) @ ( zero_zero @ ( poly @ A ) ) @ R @ D @ Dr @ N )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% divide_poly_main_0
thf(fact_38_not__eq__pos__or__neg__iff__1,axiom,
    ! [Lb2: real,Ub: real,P: poly @ real] :
      ( ( ! [Z3: real] :
            ( ( ( ord_less @ real @ Lb2 @ Z3 )
              & ( ord_less_eq @ real @ Z3 @ Ub ) )
           => ( ( poly2 @ real @ P @ Z3 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z3: real] :
            ( ( ( ord_less @ real @ Lb2 @ Z3 )
              & ( ord_less_eq @ real @ Z3 @ Ub ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ Z3 ) ) )
        | ! [Z3: real] :
            ( ( ( ord_less @ real @ Lb2 @ Z3 )
              & ( ord_less_eq @ real @ Z3 @ Ub ) )
           => ( ord_less @ real @ ( poly2 @ real @ P @ Z3 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_1
thf(fact_39__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062lb2_O_A_092_060forall_062x_092_060le_062lb2_O_Asgn_A_Ipoly_Ap_Ax_J_A_061_Asgn__neg__inf_Ap_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Lb22: real] :
        ~ ! [X: real] :
            ( ( ord_less_eq @ real @ X @ Lb22 )
           => ( ( sgn_sgn @ real @ ( poly2 @ real @ p @ X ) )
              = ( sturm_1439882693eg_inf @ real @ p ) ) ) ).

% \<open>\<And>thesis. (\<And>lb2. \<forall>x\<le>lb2. sgn (poly p x) = sgn_neg_inf p \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_40_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_41_min_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ ( ord_min @ A @ B @ C ) )
          = ( ( ord_less_eq @ A @ A2 @ B )
            & ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% min.bounded_iff
thf(fact_42_reflect__poly__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( reflect_poly @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% reflect_poly_0
thf(fact_43_poly__shift__id,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( poly_shift @ A @ ( zero_zero @ nat ) )
        = ( ^ [X4: poly @ A] : X4 ) ) ) ).

% poly_shift_id
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P3: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P3 ) )
      = ( P3 @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P3: A > $o,Q2: A > $o] :
      ( ! [X3: A] :
          ( ( P3 @ X3 )
          = ( Q2 @ X3 ) )
     => ( ( collect @ A @ P3 )
        = ( collect @ A @ Q2 ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B3: $tType,A: $tType,F: A > B3,G: A > B3] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_that,axiom,
    ! [Lb2: real] :
      ( ! [X3: real] :
          ( ( ( poly2 @ real @ p @ X3 )
            = ( zero_zero @ real ) )
         => ( ord_less @ real @ Lb2 @ X3 ) )
     => ( ! [X3: real] :
            ( ( ord_less_eq @ real @ X3 @ Lb2 )
           => ( ( sgn_sgn @ real @ ( poly2 @ real @ p @ X3 ) )
              = ( sturm_1439882693eg_inf @ real @ p ) ) )
       => thesis ) ) ).

% that
thf(fact_49_complete__real,axiom,
    ! [S: set @ real] :
      ( ? [X: real] : ( member @ real @ X @ S )
     => ( ? [Z2: real] :
          ! [X3: real] :
            ( ( member @ real @ X3 @ S )
           => ( ord_less_eq @ real @ X3 @ Z2 ) )
       => ? [Y2: real] :
            ( ! [X: real] :
                ( ( member @ real @ X @ S )
               => ( ord_less_eq @ real @ X @ Y2 ) )
            & ! [Z2: real] :
                ( ! [X3: real] :
                    ( ( member @ real @ X3 @ S )
                   => ( ord_less_eq @ real @ X3 @ Z2 ) )
               => ( ord_less_eq @ real @ Y2 @ Z2 ) ) ) ) ) ).

% complete_real
thf(fact_50_divide__poly__main_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( idom_divide @ A )
     => ! [Lc: A,Q: poly @ A,R: poly @ A,D: poly @ A,Dr: nat] :
          ( ( divide_poly_main @ A @ Lc @ Q @ R @ D @ Dr @ ( zero_zero @ nat ) )
          = Q ) ) ).

% divide_poly_main.simps(2)
thf(fact_51_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X2: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X2 ) ) ).

% zero_le
thf(fact_52_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_53_less__eq__real__def,axiom,
    ( ( ord_less_eq @ real )
    = ( ^ [X4: real,Y3: real] :
          ( ( ord_less @ real @ X4 @ Y3 )
          | ( X4 = Y3 ) ) ) ) ).

% less_eq_real_def
thf(fact_54_min_Omono,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,C: A,B: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ C )
         => ( ( ord_less_eq @ A @ B @ D )
           => ( ord_less_eq @ A @ ( ord_min @ A @ A2 @ B ) @ ( ord_min @ A @ C @ D ) ) ) ) ) ).

% min.mono
thf(fact_55_min_OorderE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( A2
            = ( ord_min @ A @ A2 @ B ) ) ) ) ).

% min.orderE
thf(fact_56_min_OorderI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( A2
            = ( ord_min @ A @ A2 @ B ) )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% min.orderI
thf(fact_57_min_Oabsorb1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_min @ A @ A2 @ B )
            = A2 ) ) ) ).

% min.absorb1
thf(fact_58_min_Oabsorb2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_min @ A @ A2 @ B )
            = B ) ) ) ).

% min.absorb2
thf(fact_59_min_OboundedE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ ( ord_min @ A @ B @ C ) )
         => ~ ( ( ord_less_eq @ A @ A2 @ B )
             => ~ ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% min.boundedE
thf(fact_60_min_OboundedI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ A2 @ C )
           => ( ord_less_eq @ A @ A2 @ ( ord_min @ A @ B @ C ) ) ) ) ) ).

% min.boundedI
thf(fact_61_min_Oorder__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B2: A] :
              ( A3
              = ( ord_min @ A @ A3 @ B2 ) ) ) ) ) ).

% min.order_iff
thf(fact_62_min_Ocobounded1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] : ( ord_less_eq @ A @ ( ord_min @ A @ A2 @ B ) @ A2 ) ) ).

% min.cobounded1
thf(fact_63_min_Ocobounded2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] : ( ord_less_eq @ A @ ( ord_min @ A @ A2 @ B ) @ B ) ) ).

% min.cobounded2
thf(fact_64_min_Oabsorb__iff1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B2: A] :
              ( ( ord_min @ A @ A3 @ B2 )
              = A3 ) ) ) ) ).

% min.absorb_iff1
thf(fact_65_min_Oabsorb__iff2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [B2: A,A3: A] :
              ( ( ord_min @ A @ A3 @ B2 )
              = B2 ) ) ) ) ).

% min.absorb_iff2
thf(fact_66_min_OcoboundedI1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ C )
         => ( ord_less_eq @ A @ ( ord_min @ A @ A2 @ B ) @ C ) ) ) ).

% min.coboundedI1
thf(fact_67_min_OcoboundedI2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [B: A,C: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ C )
         => ( ord_less_eq @ A @ ( ord_min @ A @ A2 @ B ) @ C ) ) ) ).

% min.coboundedI2
thf(fact_68_min__le__iff__disj,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ ( ord_min @ A @ X2 @ Y ) @ Z )
          = ( ( ord_less_eq @ A @ X2 @ Z )
            | ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% min_le_iff_disj
thf(fact_69_order__0I,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A2: A] :
          ( ( ( poly2 @ A @ P @ A2 )
           != ( zero_zero @ A ) )
         => ( ( order2 @ A @ A2 @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% order_0I
thf(fact_70_not__eq__pos__or__neg__iff__2,axiom,
    ! [Lb2: real,Ub: real,P: poly @ real] :
      ( ( ! [Z3: real] :
            ( ( ( ord_less_eq @ real @ Lb2 @ Z3 )
              & ( ord_less @ real @ Z3 @ Ub ) )
           => ( ( poly2 @ real @ P @ Z3 )
             != ( zero_zero @ real ) ) ) )
      = ( ! [Z3: real] :
            ( ( ( ord_less_eq @ real @ Lb2 @ Z3 )
              & ( ord_less @ real @ Z3 @ Ub ) )
           => ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ Z3 ) ) )
        | ! [Z3: real] :
            ( ( ( ord_less_eq @ real @ Lb2 @ Z3 )
              & ( ord_less @ real @ Z3 @ Ub ) )
           => ( ord_less @ real @ ( poly2 @ real @ P @ Z3 ) @ ( zero_zero @ real ) ) ) ) ) ).

% not_eq_pos_or_neg_iff_2
thf(fact_71_zero__le__sgn__iff,axiom,
    ! [X2: real] :
      ( ( ord_less_eq @ real @ ( zero_zero @ real ) @ ( sgn_sgn @ real @ X2 ) )
      = ( ord_less_eq @ real @ ( zero_zero @ real ) @ X2 ) ) ).

% zero_le_sgn_iff
thf(fact_72_sgn__le__0__iff,axiom,
    ! [X2: real] :
      ( ( ord_less_eq @ real @ ( sgn_sgn @ real @ X2 ) @ ( zero_zero @ real ) )
      = ( ord_less_eq @ real @ X2 @ ( zero_zero @ real ) ) ) ).

% sgn_le_0_iff
thf(fact_73_sgn__greater,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( sgn_sgn @ A @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% sgn_greater
thf(fact_74_sgn__less,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( sgn_sgn @ A @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% sgn_less
thf(fact_75_root__ub,axiom,
    ! [P: poly @ real] :
      ( ( P
       != ( zero_zero @ ( poly @ real ) ) )
     => ~ ! [Ub2: real] :
            ( ! [X: real] :
                ( ( ( poly2 @ real @ P @ X )
                  = ( zero_zero @ real ) )
               => ( ord_less @ real @ X @ Ub2 ) )
           => ~ ! [X: real] :
                  ( ( ord_less_eq @ real @ Ub2 @ X )
                 => ( ( sgn_sgn @ real @ ( poly2 @ real @ P @ X ) )
                    = ( sturm_62398785os_inf @ real @ P ) ) ) ) ) ).

% root_ub
thf(fact_76_sgn__0,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ( ( sgn_sgn @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% sgn_0
thf(fact_77_sgn__zero,axiom,
    ! [A: $tType] :
      ( ( real_V55928688vector @ A )
     => ( ( sgn_sgn @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% sgn_zero
thf(fact_78_sgn__sgn,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ! [A2: A] :
          ( ( sgn_sgn @ A @ ( sgn_sgn @ A @ A2 ) )
          = ( sgn_sgn @ A @ A2 ) ) ) ).

% sgn_sgn
thf(fact_79_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X2: A,Y: A] :
          ( ( X2 != Y )
         => ( ~ ( ord_less @ A @ X2 @ Y )
           => ( ord_less @ A @ Y @ X2 ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_80_sgn__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ! [A2: A] :
          ( ( ( sgn_sgn @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% sgn_eq_0_iff
thf(fact_81_sgn__0__0,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A] :
          ( ( ( sgn_sgn @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% sgn_0_0
thf(fact_82_sgn__zero__iff,axiom,
    ! [A: $tType] :
      ( ( real_V55928688vector @ A )
     => ! [X2: A] :
          ( ( ( sgn_sgn @ A @ X2 )
            = ( zero_zero @ A ) )
          = ( X2
            = ( zero_zero @ A ) ) ) ) ).

% sgn_zero_iff
thf(fact_83_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_84_bot__nat__0_Oextremum,axiom,
    ! [A2: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ A2 ) ).

% bot_nat_0.extremum
thf(fact_85_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_86_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_87_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A2: nat] :
      ( ( A2
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A2 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_88_min__0R,axiom,
    ! [N: nat] :
      ( ( ord_min @ nat @ N @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% min_0R
thf(fact_89_min__0L,axiom,
    ! [N: nat] :
      ( ( ord_min @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% min_0L
thf(fact_90_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_91_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_92_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_93_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_94_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_95_Nat_Oex__has__greatest__nat,axiom,
    ! [P3: nat > $o,K: nat,B: nat] :
      ( ( P3 @ K )
     => ( ! [Y2: nat] :
            ( ( P3 @ Y2 )
           => ( ord_less_eq @ nat @ Y2 @ B ) )
       => ? [X3: nat] :
            ( ( P3 @ X3 )
            & ! [Y4: nat] :
                ( ( P3 @ Y4 )
               => ( ord_less_eq @ nat @ Y4 @ X3 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_96_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_97_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( M != N )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_98_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less @ nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_99_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less @ nat @ M2 @ N2 )
          | ( M2 = N2 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_100_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_101_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_eq @ nat @ M2 @ N2 )
          & ( M2 != N2 ) ) ) ) ).

% nat_less_le
thf(fact_102_infinite__descent__measure,axiom,
    ! [A: $tType,P3: A > $o,V: A > nat,X2: A] :
      ( ! [X3: A] :
          ( ~ ( P3 @ X3 )
         => ? [Y4: A] :
              ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X3 ) )
              & ~ ( P3 @ Y4 ) ) )
     => ( P3 @ X2 ) ) ).

% infinite_descent_measure
thf(fact_103_linorder__neqE__nat,axiom,
    ! [X2: nat,Y: nat] :
      ( ( X2 != Y )
     => ( ~ ( ord_less @ nat @ X2 @ Y )
       => ( ord_less @ nat @ Y @ X2 ) ) ) ).

% linorder_neqE_nat
thf(fact_104_infinite__descent,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ~ ( P3 @ N3 )
         => ? [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
              & ~ ( P3 @ M3 ) ) )
     => ( P3 @ N ) ) ).

% infinite_descent
thf(fact_105_nat__less__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
             => ( P3 @ M3 ) )
         => ( P3 @ N3 ) )
     => ( P3 @ N ) ) ).

% nat_less_induct
thf(fact_106_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_107_less__not__refl3,axiom,
    ! [S2: nat,T: nat] :
      ( ( ord_less @ nat @ S2 @ T )
     => ( S2 != T ) ) ).

% less_not_refl3
thf(fact_108_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_109_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_110_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_111_measure__induct__rule,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( wellorder @ B3 )
     => ! [F: A > B3,P3: A > $o,A2: A] :
          ( ! [X3: A] :
              ( ! [Y4: A] :
                  ( ( ord_less @ B3 @ ( F @ Y4 ) @ ( F @ X3 ) )
                 => ( P3 @ Y4 ) )
             => ( P3 @ X3 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct_rule
thf(fact_112_measure__induct,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( wellorder @ B3 )
     => ! [F: A > B3,P3: A > $o,A2: A] :
          ( ! [X3: A] :
              ( ! [Y4: A] :
                  ( ( ord_less @ B3 @ ( F @ Y4 ) @ ( F @ X3 ) )
                 => ( P3 @ Y4 ) )
             => ( P3 @ X3 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct
thf(fact_113_infinite__descent0__measure,axiom,
    ! [A: $tType,V: A > nat,P3: A > $o,X2: A] :
      ( ! [X3: A] :
          ( ( ( V @ X3 )
            = ( zero_zero @ nat ) )
         => ( P3 @ X3 ) )
     => ( ! [X3: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V @ X3 ) )
           => ( ~ ( P3 @ X3 )
             => ? [Y4: A] :
                  ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X3 ) )
                  & ~ ( P3 @ Y4 ) ) ) )
       => ( P3 @ X2 ) ) ) ).

% infinite_descent0_measure
thf(fact_114_bot__nat__0_Oextremum__strict,axiom,
    ! [A2: nat] :
      ~ ( ord_less @ nat @ A2 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_115_infinite__descent0,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ ( zero_zero @ nat ) )
     => ( ! [N3: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 )
           => ( ~ ( P3 @ N3 )
             => ? [M3: nat] :
                  ( ( ord_less @ nat @ M3 @ N3 )
                  & ~ ( P3 @ M3 ) ) ) )
       => ( P3 @ N ) ) ) ).

% infinite_descent0
thf(fact_116_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_117_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_118_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_119_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_120_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_121_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% less_eq_nat.simps(1)
thf(fact_122_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq @ nat @ N @ ( zero_zero @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% le_0_eq
thf(fact_123_ex__least__nat__le,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ N )
     => ( ~ ( P3 @ ( zero_zero @ nat ) )
       => ? [K2: nat] :
            ( ( ord_less_eq @ nat @ K2 @ N )
            & ! [I3: nat] :
                ( ( ord_less @ nat @ I3 @ K2 )
               => ~ ( P3 @ I3 ) )
            & ( P3 @ K2 ) ) ) ) ).

% ex_least_nat_le
thf(fact_124_bot__nat__0_Oextremum__unique,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
      = ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_unique
thf(fact_125_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
     => ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_126_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A] : ( ord_less_eq @ A @ X2 @ X2 ) ) ).

% order_refl
thf(fact_127_min__absorb1,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ord_min @ A @ X2 @ Y )
            = X2 ) ) ) ).

% min_absorb1
thf(fact_128_min__absorb2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y: A,X2: A] :
          ( ( ord_less_eq @ A @ Y @ X2 )
         => ( ( ord_min @ A @ X2 @ Y )
            = Y ) ) ) ).

% min_absorb2
thf(fact_129_min__def,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ( ( ord_min @ A )
        = ( ^ [A3: A,B2: A] : ( if @ A @ ( ord_less_eq @ A @ A3 @ B2 ) @ A3 @ B2 ) ) ) ) ).

% min_def
thf(fact_130_Lattices__Big_Oex__has__greatest__nat,axiom,
    ! [A: $tType,P3: A > $o,K: A,F: A > nat,B: nat] :
      ( ( P3 @ K )
     => ( ! [Y2: A] :
            ( ( P3 @ Y2 )
           => ( ord_less @ nat @ ( F @ Y2 ) @ B ) )
       => ? [X3: A] :
            ( ( P3 @ X3 )
            & ! [Y4: A] :
                ( ( P3 @ Y4 )
               => ( ord_less_eq @ nat @ ( F @ Y4 ) @ ( F @ X3 ) ) ) ) ) ) ).

% Lattices_Big.ex_has_greatest_nat
thf(fact_131_nat__descend__induct,axiom,
    ! [N: nat,P3: nat > $o,M: nat] :
      ( ! [K2: nat] :
          ( ( ord_less @ nat @ N @ K2 )
         => ( P3 @ K2 ) )
     => ( ! [K2: nat] :
            ( ( ord_less_eq @ nat @ K2 @ N )
           => ( ! [I3: nat] :
                  ( ( ord_less @ nat @ K2 @ I3 )
                 => ( P3 @ I3 ) )
             => ( P3 @ K2 ) ) )
       => ( P3 @ M ) ) ) ).

% nat_descend_induct
thf(fact_132_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( A2 = B ) ) ) ) ).

% dual_order.antisym
thf(fact_133_dual__order_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [A3: A,B2: A] :
              ( ( ord_less_eq @ A @ B2 @ A3 )
              & ( ord_less_eq @ A @ A3 @ B2 ) ) ) ) ) ).

% dual_order.eq_iff
thf(fact_134_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_135_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > A > $o,A2: A,B: A] :
          ( ! [A5: A,B4: A] :
              ( ( ord_less_eq @ A @ A5 @ B4 )
             => ( P3 @ A5 @ B4 ) )
         => ( ! [A5: A,B4: A] :
                ( ( P3 @ B4 @ A5 )
               => ( P3 @ A5 @ B4 ) )
           => ( P3 @ A2 @ B ) ) ) ) ).

% linorder_wlog
thf(fact_136_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_137_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X2 @ Z ) ) ) ) ).

% order_trans
thf(fact_138_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( A2 = B ) ) ) ) ).

% order_class.order.antisym
thf(fact_139_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_140_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_141_order__class_Oorder_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [A3: A,B2: A] :
              ( ( ord_less_eq @ A @ A3 @ B2 )
              & ( ord_less_eq @ A @ B2 @ A3 ) ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_142_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y: A,X2: A] :
          ( ( ord_less_eq @ A @ Y @ X2 )
         => ( ( ord_less_eq @ A @ X2 @ Y )
            = ( X2 = Y ) ) ) ) ).

% antisym_conv
thf(fact_143_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X2 @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X2 )
             => ~ ( ord_less_eq @ A @ X2 @ Z ) )
           => ( ( ( ord_less_eq @ A @ X2 @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X2 ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X2 ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X2 )
                     => ~ ( ord_less_eq @ A @ X2 @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_144_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_145_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X2 @ Y )
         => ( ord_less_eq @ A @ Y @ X2 ) ) ) ).

% le_cases
thf(fact_146_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A] :
          ( ( X2 = Y )
         => ( ord_less_eq @ A @ X2 @ Y ) ) ) ).

% eq_refl
thf(fact_147_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
          | ( ord_less_eq @ A @ Y @ X2 ) ) ) ).

% linear
thf(fact_148_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ord_less_eq @ A @ Y @ X2 )
           => ( X2 = Y ) ) ) ) ).

% antisym
thf(fact_149_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [X4: A,Y3: A] :
              ( ( ord_less_eq @ A @ X4 @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X4 ) ) ) ) ) ).

% eq_iff
thf(fact_150_ord__le__eq__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 )
        & ( ord @ A ) )
     => ! [A2: A,B: A,F: A > B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y2 )
                 => ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less_eq @ B3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_151_ord__eq__le__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 )
        & ( ord @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less_eq @ B3 @ X3 @ Y2 )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_152_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ C2 @ ( F @ B ) @ C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y2 )
                 => ( ord_less_eq @ C2 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_153_order__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 )
        & ( order @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less_eq @ B3 @ X3 @ Y2 )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_154_le__fun__def,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 )
     => ( ( ord_less_eq @ ( A > B3 ) )
        = ( ^ [F2: A > B3,G2: A > B3] :
            ! [X4: A] : ( ord_less_eq @ B3 @ ( F2 @ X4 ) @ ( G2 @ X4 ) ) ) ) ) ).

% le_fun_def
thf(fact_155_le__funI,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 )
     => ! [F: A > B3,G: A > B3] :
          ( ! [X3: A] : ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( G @ X3 ) )
         => ( ord_less_eq @ ( A > B3 ) @ F @ G ) ) ) ).

% le_funI
thf(fact_156_le__funE,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 )
     => ! [F: A > B3,G: A > B3,X2: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ).

% le_funE
thf(fact_157_le__funD,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 )
     => ! [F: A > B3,G: A > B3,X2: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ).

% le_funD
thf(fact_158_ord__eq__less__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 )
        & ( ord @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less @ B3 @ X3 @ Y2 )
                 => ( ord_less @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_159_ord__less__eq__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 )
        & ( ord @ A ) )
     => ! [A2: A,B: A,F: A > B3,C: B3] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less @ A @ X3 @ Y2 )
                 => ( ord_less @ B3 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ B3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_160_order__less__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 )
        & ( order @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less @ B3 @ X3 @ Y2 )
                 => ( ord_less @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_161_order__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ C2 @ ( F @ B ) @ C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less @ A @ X3 @ Y2 )
                 => ( ord_less @ C2 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_subst2
thf(fact_162_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A )
     => ! [X2: A] :
        ? [Y2: A] : ( ord_less @ A @ Y2 @ X2 ) ) ).

% lt_ex
thf(fact_163_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A )
     => ! [X2: A] :
        ? [X_1: A] : ( ord_less @ A @ X2 @ X_1 ) ) ).

% gt_ex
thf(fact_164_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( X2 != Y )
         => ( ~ ( ord_less @ A @ X2 @ Y )
           => ( ord_less @ A @ Y @ X2 ) ) ) ) ).

% neqE
thf(fact_165_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( X2 != Y )
          = ( ( ord_less @ A @ X2 @ Y )
            | ( ord_less @ A @ Y @ X2 ) ) ) ) ).

% neq_iff
thf(fact_166_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ~ ( ord_less @ A @ B @ A2 ) ) ) ).

% order.asym
thf(fact_167_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ? [Z5: A] :
              ( ( ord_less @ A @ X2 @ Z5 )
              & ( ord_less @ A @ Z5 @ Y ) ) ) ) ).

% dense
thf(fact_168_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( X2 != Y ) ) ) ).

% less_imp_neq
thf(fact_169_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ~ ( ord_less @ A @ Y @ X2 ) ) ) ).

% less_asym
thf(fact_170_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ~ ( ord_less @ A @ B @ A2 ) ) ) ).

% less_asym'
thf(fact_171_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( ( ord_less @ A @ Y @ Z )
           => ( ord_less @ A @ X2 @ Z ) ) ) ) ).

% less_trans
thf(fact_172_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
          | ( X2 = Y )
          | ( ord_less @ A @ Y @ X2 ) ) ) ).

% less_linear
thf(fact_173_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A] :
          ~ ( ord_less @ A @ X2 @ X2 ) ) ).

% less_irrefl
thf(fact_174_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_eq_less_trans
thf(fact_175_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_less_eq_trans
thf(fact_176_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ~ ( ord_less @ A @ A2 @ B ) ) ) ).

% dual_order.asym
thf(fact_177_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( X2 != Y ) ) ) ).

% less_imp_not_eq
thf(fact_178_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ~ ( ord_less @ A @ Y @ X2 ) ) ) ).

% less_not_sym
thf(fact_179_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ! [P3: A > $o,A2: A] :
          ( ! [X3: A] :
              ( ! [Y4: A] :
                  ( ( ord_less @ A @ Y4 @ X3 )
                 => ( P3 @ Y4 ) )
             => ( P3 @ X3 ) )
         => ( P3 @ A2 ) ) ) ).

% less_induct
thf(fact_180_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y: A,X2: A] :
          ( ~ ( ord_less @ A @ Y @ X2 )
         => ( ( ~ ( ord_less @ A @ X2 @ Y ) )
            = ( X2 = Y ) ) ) ) ).

% antisym_conv3
thf(fact_181_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( Y != X2 ) ) ) ).

% less_imp_not_eq2
thf(fact_182_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A,P3: $o] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( ( ord_less @ A @ Y @ X2 )
           => P3 ) ) ) ).

% less_imp_triv
thf(fact_183_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ~ ( ord_less @ A @ X2 @ Y )
         => ( ( X2 != Y )
           => ( ord_less @ A @ Y @ X2 ) ) ) ) ).

% linorder_cases
thf(fact_184_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% dual_order.irrefl
thf(fact_185_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans
thf(fact_186_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ~ ( ord_less @ A @ Y @ X2 ) ) ) ).

% less_imp_not_less
thf(fact_187_exists__least__iff,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A )
     => ( ( ^ [P4: A > $o] :
            ? [X5: A] : ( P4 @ X5 ) )
        = ( ^ [P5: A > $o] :
            ? [N2: A] :
              ( ( P5 @ N2 )
              & ! [M2: A] :
                  ( ( ord_less @ A @ M2 @ N2 )
                 => ~ ( P5 @ M2 ) ) ) ) ) ) ).

% exists_least_iff
thf(fact_188_linorder__less__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > A > $o,A2: A,B: A] :
          ( ! [A5: A,B4: A] :
              ( ( ord_less @ A @ A5 @ B4 )
             => ( P3 @ A5 @ B4 ) )
         => ( ! [A5: A] : ( P3 @ A5 @ A5 )
           => ( ! [A5: A,B4: A] :
                  ( ( P3 @ B4 @ A5 )
                 => ( P3 @ A5 @ B4 ) )
             => ( P3 @ A2 @ B ) ) ) ) ) ).

% linorder_less_wlog
thf(fact_189_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_190_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X2 @ Y ) )
          = ( ( ord_less @ A @ Y @ X2 )
            | ( X2 = Y ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_191_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( A2 != B ) ) ) ).

% order.strict_implies_not_eq
thf(fact_192_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( A2 != B ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_193_ex__has__least__nat,axiom,
    ! [A: $tType,P3: A > $o,K: A,M: A > nat] :
      ( ( P3 @ K )
     => ? [X3: A] :
          ( ( P3 @ X3 )
          & ! [Y4: A] :
              ( ( P3 @ Y4 )
             => ( ord_less_eq @ nat @ ( M @ X3 ) @ ( M @ Y4 ) ) ) ) ) ).

% ex_has_least_nat
thf(fact_194_leD,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y: A,X2: A] :
          ( ( ord_less_eq @ A @ Y @ X2 )
         => ~ ( ord_less @ A @ X2 @ Y ) ) ) ).

% leD
thf(fact_195_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ~ ( ord_less @ A @ X2 @ Y )
         => ( ord_less_eq @ A @ Y @ X2 ) ) ) ).

% leI
thf(fact_196_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [X4: A,Y3: A] :
              ( ( ord_less @ A @ X4 @ Y3 )
              | ( X4 = Y3 ) ) ) ) ) ).

% le_less
thf(fact_197_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [X4: A,Y3: A] :
              ( ( ord_less_eq @ A @ X4 @ Y3 )
              & ( X4 != Y3 ) ) ) ) ) ).

% less_le
thf(fact_198_order__le__less__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 )
        & ( order @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less @ B3 @ X3 @ Y2 )
                 => ( ord_less @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_199_order__le__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less @ C2 @ ( F @ B ) @ C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y2 )
                 => ( ord_less_eq @ C2 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_200_order__less__le__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 )
        & ( order @ A ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X3: B3,Y2: B3] :
                  ( ( ord_less_eq @ B3 @ X3 @ Y2 )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_201_order__less__le__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 )
        & ( order @ A ) )
     => ! [A2: A,B: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less_eq @ C2 @ ( F @ B ) @ C )
           => ( ! [X3: A,Y2: A] :
                  ( ( ord_less @ A @ X3 @ Y2 )
                 => ( ord_less @ C2 @ ( F @ X3 ) @ ( F @ Y2 ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_202_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ~ ( ord_less_eq @ A @ X2 @ Y ) )
          = ( ord_less @ A @ Y @ X2 ) ) ) ).

% not_le
thf(fact_203_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X2 @ Y ) )
          = ( ord_less_eq @ A @ Y @ X2 ) ) ) ).

% not_less
thf(fact_204_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( A2 != B )
           => ( ord_less @ A @ A2 @ B ) ) ) ) ).

% le_neq_trans
thf(fact_205_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ~ ( ord_less @ A @ X2 @ Y )
         => ( ( ord_less_eq @ A @ X2 @ Y )
            = ( X2 = Y ) ) ) ) ).

% antisym_conv1
thf(fact_206_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ~ ( ord_less @ A @ X2 @ Y ) )
            = ( X2 = Y ) ) ) ) ).

% antisym_conv2
thf(fact_207_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( ord_less_eq @ A @ X2 @ Y ) ) ) ).

% less_imp_le
thf(fact_208_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ord_less @ A @ Y @ Z )
           => ( ord_less @ A @ X2 @ Z ) ) ) ) ).

% le_less_trans
thf(fact_209_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less @ A @ X2 @ Z ) ) ) ) ).

% less_le_trans
thf(fact_210_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z: A,Y: A] :
          ( ! [X3: A] :
              ( ( ord_less @ A @ Z @ X3 )
             => ( ord_less_eq @ A @ Y @ X3 ) )
         => ( ord_less_eq @ A @ Y @ Z ) ) ) ).

% dense_ge
thf(fact_211_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Y: A,Z: A] :
          ( ! [X3: A] :
              ( ( ord_less @ A @ X3 @ Y )
             => ( ord_less_eq @ A @ X3 @ Z ) )
         => ( ord_less_eq @ A @ Y @ Z ) ) ) ).

% dense_le
thf(fact_212_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
          | ( ord_less @ A @ Y @ X2 ) ) ) ).

% le_less_linear
thf(fact_213_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X2: A,Y: A] :
          ( ( ord_less_eq @ A @ X2 @ Y )
         => ( ( ord_less @ A @ X2 @ Y )
            | ( X2 = Y ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_214_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ( ( ord_less @ A )
        = ( ^ [X4: A,Y3: A] :
              ( ( ord_less_eq @ A @ X4 @ Y3 )
              & ~ ( ord_less_eq @ A @ Y3 @ X4 ) ) ) ) ) ).

% less_le_not_le
thf(fact_215_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Y: A,X2: A] :
          ( ~ ( ord_less_eq @ A @ Y @ X2 )
         => ( ord_less @ A @ X2 @ Y ) ) ) ).

% not_le_imp_less
thf(fact_216_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans1
thf(fact_217_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans2
thf(fact_218_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B2: A] :
              ( ( ord_less @ A @ A3 @ B2 )
              | ( A3 = B2 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_219_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [A3: A,B2: A] :
              ( ( ord_less_eq @ A @ A3 @ B2 )
              & ( A3 != B2 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_220_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_221_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_222_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [Z: A,X2: A,Y: A] :
          ( ( ord_less @ A @ Z @ X2 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z @ W )
               => ( ( ord_less @ A @ W @ X2 )
                 => ( ord_less_eq @ A @ Y @ W ) ) )
           => ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% dense_ge_bounded
thf(fact_223_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A )
     => ! [X2: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X2 @ Y )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X2 @ W )
               => ( ( ord_less @ A @ W @ Y )
                 => ( ord_less_eq @ A @ W @ Z ) ) )
           => ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% dense_le_bounded
thf(fact_224_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% order.strict_implies_order
thf(fact_225_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [B2: A,A3: A] :
              ( ( ord_less @ A @ B2 @ A3 )
              | ( A3 = B2 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_226_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ord_less @ A )
        = ( ^ [B2: A,A3: A] :
              ( ( ord_less_eq @ A @ B2 @ A3 )
              & ( A3 != B2 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_227_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ord_less_eq @ A @ B @ A2 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_228_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B: A] :
          ( ( A2 != B )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( ord_less @ A @ A2 @ B ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_229_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ~ ( ord_less_eq @ A @ T @ X ) ) ) ).

% minf(8)
thf(fact_230_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ( ord_less_eq @ A @ X @ T ) ) ) ).

% minf(6)
thf(fact_231_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ( ord_less_eq @ A @ T @ X ) ) ) ).

% pinf(8)
thf(fact_232_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ~ ( ord_less_eq @ A @ X @ T ) ) ) ).

% pinf(6)
thf(fact_233_less__fun__def,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 )
     => ( ( ord_less @ ( A > B3 ) )
        = ( ^ [F2: A > B3,G2: A > B3] :
              ( ( ord_less_eq @ ( A > B3 ) @ F2 @ G2 )
              & ~ ( ord_less_eq @ ( A > B3 ) @ G2 @ F2 ) ) ) ) ) ).

% less_fun_def
thf(fact_234_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P6: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z2: A] :
            ! [X3: A] :
              ( ( ord_less @ A @ Z2 @ X3 )
             => ( ( P3 @ X3 )
                = ( P6 @ X3 ) ) )
         => ( ? [Z2: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ Z2 @ X3 )
               => ( ( Q2 @ X3 )
                  = ( Q3 @ X3 ) ) )
           => ? [Z5: A] :
              ! [X: A] :
                ( ( ord_less @ A @ Z5 @ X )
               => ( ( ( P3 @ X )
                    & ( Q2 @ X ) )
                  = ( ( P6 @ X )
                    & ( Q3 @ X ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_235_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P6: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z2: A] :
            ! [X3: A] :
              ( ( ord_less @ A @ Z2 @ X3 )
             => ( ( P3 @ X3 )
                = ( P6 @ X3 ) ) )
         => ( ? [Z2: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ Z2 @ X3 )
               => ( ( Q2 @ X3 )
                  = ( Q3 @ X3 ) ) )
           => ? [Z5: A] :
              ! [X: A] :
                ( ( ord_less @ A @ Z5 @ X )
               => ( ( ( P3 @ X )
                    | ( Q2 @ X ) )
                  = ( ( P6 @ X )
                    | ( Q3 @ X ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_236_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ( X != T ) ) ) ).

% pinf(3)
thf(fact_237_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ( X != T ) ) ) ).

% pinf(4)
thf(fact_238_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ~ ( ord_less @ A @ X @ T ) ) ) ).

% pinf(5)
thf(fact_239_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z5 @ X )
         => ( ord_less @ A @ T @ X ) ) ) ).

% pinf(7)
thf(fact_240_pinf_I11_J,axiom,
    ! [C2: $tType,D3: $tType] :
      ( ( ord @ C2 )
     => ! [F3: D3] :
        ? [Z5: C2] :
        ! [X: C2] :
          ( ( ord_less @ C2 @ Z5 @ X )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_241_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P6: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z2: A] :
            ! [X3: A] :
              ( ( ord_less @ A @ X3 @ Z2 )
             => ( ( P3 @ X3 )
                = ( P6 @ X3 ) ) )
         => ( ? [Z2: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ X3 @ Z2 )
               => ( ( Q2 @ X3 )
                  = ( Q3 @ X3 ) ) )
           => ? [Z5: A] :
              ! [X: A] :
                ( ( ord_less @ A @ X @ Z5 )
               => ( ( ( P3 @ X )
                    & ( Q2 @ X ) )
                  = ( ( P6 @ X )
                    & ( Q3 @ X ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_242_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P3: A > $o,P6: A > $o,Q2: A > $o,Q3: A > $o] :
          ( ? [Z2: A] :
            ! [X3: A] :
              ( ( ord_less @ A @ X3 @ Z2 )
             => ( ( P3 @ X3 )
                = ( P6 @ X3 ) ) )
         => ( ? [Z2: A] :
              ! [X3: A] :
                ( ( ord_less @ A @ X3 @ Z2 )
               => ( ( Q2 @ X3 )
                  = ( Q3 @ X3 ) ) )
           => ? [Z5: A] :
              ! [X: A] :
                ( ( ord_less @ A @ X @ Z5 )
               => ( ( ( P3 @ X )
                    | ( Q2 @ X ) )
                  = ( ( P6 @ X )
                    | ( Q3 @ X ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_243_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ( X != T ) ) ) ).

% minf(3)
thf(fact_244_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ( X != T ) ) ) ).

% minf(4)
thf(fact_245_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ( ord_less @ A @ X @ T ) ) ) ).

% minf(5)
thf(fact_246_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [T: A] :
        ? [Z5: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z5 )
         => ~ ( ord_less @ A @ T @ X ) ) ) ).

% minf(7)
thf(fact_247_minf_I11_J,axiom,
    ! [C2: $tType,D3: $tType] :
      ( ( ord @ C2 )
     => ! [F3: D3] :
        ? [Z5: C2] :
        ! [X: C2] :
          ( ( ord_less @ C2 @ X @ Z5 )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_248_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A )
     => ! [A2: A,B: A,P3: A > $o] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( P3 @ A2 )
           => ( ~ ( P3 @ B )
             => ? [C3: A] :
                  ( ( ord_less_eq @ A @ A2 @ C3 )
                  & ( ord_less_eq @ A @ C3 @ B )
                  & ! [X: A] :
                      ( ( ( ord_less_eq @ A @ A2 @ X )
                        & ( ord_less @ A @ X @ C3 ) )
                     => ( P3 @ X ) )
                  & ! [D4: A] :
                      ( ! [X3: A] :
                          ( ( ( ord_less_eq @ A @ A2 @ X3 )
                            & ( ord_less @ A @ X3 @ D4 ) )
                         => ( P3 @ X3 ) )
                     => ( ord_less_eq @ A @ D4 @ C3 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_249_verit__comp__simplify1_I3_J,axiom,
    ! [B3: $tType] :
      ( ( linorder @ B3 )
     => ! [B5: B3,A6: B3] :
          ( ( ~ ( ord_less_eq @ B3 @ B5 @ A6 ) )
          = ( ord_less @ B3 @ A6 @ B5 ) ) ) ).

% verit_comp_simplify1(3)
thf(fact_250_verit__la__disequality,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [A2: A,B: A] :
          ( ( A2 = B )
          | ~ ( ord_less_eq @ A @ A2 @ B )
          | ~ ( ord_less_eq @ A @ B @ A2 ) ) ) ).

% verit_la_disequality
thf(fact_251_verit__comp__simplify1_I1_J,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% verit_comp_simplify1(1)
thf(fact_252_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A )
     => ! [A2: A] :
        ? [B4: A] :
          ( ( ord_less @ A @ A2 @ B4 )
          | ( ord_less @ A @ B4 @ A2 ) ) ) ).

% ex_gt_or_lt
thf(fact_253_poly__cutoff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( zero_zero @ ( poly @ A ) ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( one_one @ ( poly @ A ) ) ) ) ) ) ).

% poly_cutoff_1

% Type constructors (60)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 )
     => ( preorder @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 )
     => ( order @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 )
     => ( ord @ ( A7 > A8 ) ) ) ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0 @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Ono__top,axiom,
    no_top @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Set_Oset___Orderings_Opreorder_4,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_5,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_6,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder_8,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o ).

thf(tcon_Real_Oreal___Conditionally__Complete__Lattices_Oconditionally__complete__linorder_11,axiom,
    condit1037483654norder @ real ).

thf(tcon_Real_Oreal___Conditionally__Complete__Lattices_Olinear__continuum,axiom,
    condit1656338222tinuum @ real ).

thf(tcon_Real_Oreal___Real__Vector__Spaces_Oreal__normed__vector,axiom,
    real_V55928688vector @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_12,axiom,
    linord1659791738miring @ real ).

thf(tcon_Real_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__linorder,axiom,
    dense_linorder @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_13,axiom,
    comm_semiring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__0_14,axiom,
    comm_semiring_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Odense__order,axiom,
    dense_order @ real ).

thf(tcon_Real_Oreal___Rings_Oidom__abs__sgn,axiom,
    idom_abs_sgn @ real ).

thf(tcon_Real_Oreal___Orderings_Opreorder_15,axiom,
    preorder @ real ).

thf(tcon_Real_Oreal___Orderings_Olinorder_16,axiom,
    linorder @ real ).

thf(tcon_Real_Oreal___Rings_Oidom__divide,axiom,
    idom_divide @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring__1,axiom,
    comm_ring_1 @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__top_17,axiom,
    no_top @ real ).

thf(tcon_Real_Oreal___Orderings_Ono__bot,axiom,
    no_bot @ real ).

thf(tcon_Real_Oreal___Orderings_Oorder_18,axiom,
    order @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Orderings_Oord_19,axiom,
    ord @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_20,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Rings_Oidom,axiom,
    idom @ real ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__nonzero__semiring_21,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linord1659791738miring @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__no__zero__divisors_22,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( ring_n68954251visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__idom_23,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linordered_idom @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__1_24,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( comm_semiring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__0_25,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_0 @ A7 )
     => ( comm_semiring_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom__abs__sgn_26,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( idom_abs_sgn @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Opreorder_27,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( preorder @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Olinorder_28,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linorder @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom__divide_29,axiom,
    ! [A7: $tType] :
      ( ( idom_divide @ A7 )
     => ( idom_divide @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring__1_30,axiom,
    ! [A7: $tType] :
      ( ( comm_ring_1 @ A7 )
     => ( comm_ring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oorder_31,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( order @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Oring__char__0_32,axiom,
    ! [A7: $tType] :
      ( ( ( ring_char_0 @ A7 )
        & ( comm_ring_1 @ A7 ) )
     => ( ring_char_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oord_33,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( ord @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ozero_34,axiom,
    ! [A7: $tType] :
      ( ( zero @ A7 )
     => ( zero @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom_35,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( idom @ ( poly @ A7 ) ) ) ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P3: $o] :
      ( ( P3 = $true )
      | ( P3 = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X2: A,Y: A] :
      ( ( if @ A @ $false @ X2 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X2: A,Y: A] :
      ( ( if @ A @ $true @ X2 @ Y )
      = X2 ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ! [X3: real] :
      ( ( ( poly2 @ real @ p @ X3 )
       != ( zero_zero @ real ) )
      | ( ord_less @ real @ lb @ X3 ) ) ).

%------------------------------------------------------------------------------
